package gov.va.caret.view;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.model.Facil;
import gov.va.caret.model.Persn;
import gov.va.caret.security.CAction;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;



public class CaretParam {
	
	public static final String CREATED_DATE = "createdDate";
	public static final String CREATED_BY_USER_ID = "createdByUserId";
	private static final String  CHECKBOX  = "Checkbox";
	private static double callSocDays = 0;
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static Object getParameter( PortletRequest request, ReportParameter[] reportParameters ) {
		if ( reportParameters == null || reportParameters.length ==0 ){
			return null;
		}
		if ( reportParameters.length > 1){
			Map map = new HashMap();
			for ( ReportParameter param : reportParameters ){
				map.put( param.name(), getUserOrgParameter(request, param) );
			}
			return map;
		} else {
			Object getUserOrgParameter = getUserOrgParameter ( request, reportParameters[0] );
			if ( _log.isDebugEnabled() ){
				_log.debug( reportParameters[0].name() + " =" + getUserOrgParameter );
			}
			return getUserOrgParameter;
		}
	}
	
	public static long getUserRoleId ( PortletRequest request ){
		long roleId = ((DashboardConfig) request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG)).getRoleId();
		if ( _log.isDebugEnabled() ){
			_log.debug("******************Role ID=" + roleId);
		}
		return roleId;
	}
	
	public static Object getUserOrgParameter(PortletRequest request, ReportParameter param) {
		switch ( param ){
		case userId:
			return PortalUtil.getUserId( request );
		case socDueDate:
			return StringPool.APOSTROPHE + getSocDueDateStr() + StringPool.APOSTROPHE;
		case roleId:
			return getUserRoleId(request);
		case queId:
		case userOrgIds:
			try {
				return getUserOrgs( request );
			} catch (ApplicationWorkFlowException e1) {}
		default:
			break;
		}
		
		return 0;
	}
	
	public static long getPersnId( PortletRequest request ) throws ApplicationWorkFlowException{
		Long persnId = (Long) request.getPortletSession().getAttribute(CaretStrPool.PERSN_ID );
		if ( persnId == null || persnId == 0 ){
			Persn persn = PersnLocalServiceUtil.getByUser( PortalUtil.getUserId(request) );
			if ( persn != null ){
				persnId = persn.getPersnId();
				request.getPortletSession().setAttribute(CaretStrPool.PERSN_ID, persnId );
			} else {
				try {
					_log.info("bootstrapping persnId");
					Persn bootstrap = PersnLocalServiceUtil.addPersn(PortalUtil.getUser(request), true);
					persnId = bootstrap.getPersnId();
					request.getPortletSession().setAttribute(CaretStrPool.PERSN_ID, persnId );
				} catch (Exception e) {
					throw new ApplicationWorkFlowException(e);
				}
				_log.warn("getPersnId() returns 0");
			}
		}
		return persnId;
	}
	
	public static Object getUserOrgs( PortletRequest request ) throws ApplicationWorkFlowException{
		
		String userOrgIds = (String)request.getAttribute("userOrgIds");
		if ( userOrgIds != null ){
			return userOrgIds;
		}
		List<Organization> orgs = new ArrayList<Organization>();
		try {
			List<Organization> tempOrgs = OrganizationLocalServiceUtil.getUserOrganizations( PortalUtil.getUserId(request) );
			for ( Organization org: tempOrgs ){
				if ( org.getName().startsWith("VISN") ){
					orgs.addAll( org.getSuborganizations() );
				} else {
					orgs.add(org);
				}
			}
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
		if ( orgs.size() == 0 ){
			return 0;
		} else {
			StringBuilder sb = new StringBuilder();
			for ( Organization org: orgs ){
				sb.append( org.getOrganizationId() ).append(StringPool.COMMA_AND_SPACE);
			}
			String userOrgs = sb.substring(0, sb.length()-2);
			request.setAttribute("userOrgIds", userOrgs);
			return userOrgs ;
		}
	}
	
	public static Map<Long,Facil> getFacilities( PortletRequest request ) throws ApplicationWorkFlowException{
		
		@SuppressWarnings("unchecked")
		Map<Long,Facil> facilities = (Map<Long,Facil>) request.getAttribute("facilities");
		if ( facilities != null ){
			return facilities;
		}
		List<Organization> orgs;
		Organization visn = null;
		try {
			orgs = OrganizationLocalServiceUtil.getUserOrganizations( PortalUtil.getUserId(request) );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
		if ( orgs.size() == 0 ){
			return Collections.emptyMap();
		} else {
			facilities = new HashMap<Long,Facil>();
			for ( Organization org: orgs ){
				Facil facility = FacilLocalServiceUtil.getByOrgId( org.getOrganizationId() );
				if ( facility != null ){
					facilities.put(org.getOrganizationId(), facility );
				} else if ( org.getName().toUpperCase().startsWith("VISN") ){
					visn = org;
				}
			}
			if ( visn != null ){
				try {
					for ( Organization org: visn.getDescendants() ){
						Facil facility = FacilLocalServiceUtil.getByOrgId( org.getOrganizationId() );
						if ( facility != null ){
							facilities.put(org.getOrganizationId(), facility );
						}
					}
					request.setAttribute("visn", visn);
				} catch (SystemException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
			return facilities;
		}
	}
	
	private static ConvertUtilsBean convertUtilsBean;
	public static ConvertUtilsBean getConvertUtilsBean(){
		if ( convertUtilsBean == null ){
			convertUtilsBean = new ConvertUtilsBean();
			convertUtilsBean.deregister( Date.class );
			convertUtilsBean.register( new Toolbox.DateConverter(), Date.class );
		}
		return convertUtilsBean;
	}
	
	public static BaseModel<?> loadModel ( PortletRequest request, BaseModel<?> baseModel, Collection<String> modelAtts, String prefix ) throws ApplicationWorkFlowException {
		
		BeanUtilsBean beanUtilsBean = new BeanUtilsBean( getConvertUtilsBean(), new PropertyUtilsBean() );
		Class<?> clazz = baseModel.getClass();
		_log.info( "className = " + clazz );
		for ( String name : modelAtts ){
			try {
				String value = ParamUtil.get(request, prefix == null? name : prefix + name, StringPool.BLANK );
				if ( value.isEmpty() ) continue;
				value = Toolbox.chomp(clazz, baseModel, name, value);
//				if ( _log.isDebugEnabled() ){
//					_log.debug ( name + ", value=" + value );
//				}
				beanUtilsBean.setProperty( baseModel, name, value );
			} catch (IllegalAccessException e) {
				_log.warn(e.getMessage());
			} catch (InvocationTargetException e) {
				_log.warn(e.getMessage());
			}
		}
		return baseModel;
	}
	
	public static List<Long> loadSelectedBoxModel ( PortletRequest request, String prefix ) throws ApplicationWorkFlowException {
		
		List<Long> boxGpIds = new ArrayList<Long>();
		int length = prefix.length();
		for ( Enumeration<String> enume = request.getParameterNames() ; enume.hasMoreElements(); ){
			String name = enume.nextElement();
			if ( name.startsWith(prefix) && !name.endsWith( CHECKBOX ) ){
				if ( ParamUtil.getBoolean( request, name ) ){
					long l = Long.valueOf( name.substring( length ) );
					_log.info("checked... " + l);
					boxGpIds.add(l);
				}
			}
		}
		
		return boxGpIds;
	}
	
	public static ServiceContext setOnlineServiceContext( PortletRequest request ) {
		ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
		sc.setAddGuestPermissions(false);
		
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
		sc.setAttribute( CaretStrPool.USER_ID, themeDisplay.getUser().getUserId() );
		sc.setAttribute( CaretStrPool.REAL_USER_ID, themeDisplay.getRealUser().getUserId() );
		sc.setCreateDate ( new java.util.Date() );
		sc.setAttribute( CaretStrPool.DASHBOARD_ROLE_NAME, (String)request.getPortletSession().getAttribute(CaretStrPool.ROLE_NAME) );
		return sc;
	}
	
	public static ServiceContext setCaretServiceContext( PortletRequest request ) {
		ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
		sc.setAddGuestPermissions(false);
		
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
		sc.setCreateDate ( new java.util.Date() );
		sc.setAttribute( CaretStrPool.REAL_USER_ID, themeDisplay.getRealUser().getUserId() );
		
		Object userMode = request.getPortletSession().getAttribute(CaretStrPool.IMPERSONATE);
		Long impersonateId = (Long)request.getPortletSession().getAttribute(CaretStrPool.IMPERSONATE_ID);

		DashboardConfig controller = (DashboardConfig) request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG); 
		long roleId = 0;
		if ( impersonateId!= null && impersonateId > 0 && 
				CaretStrPool.IMPERSONATE.equals(userMode) &&
				CAction.canDoCaret(request, CAction.CaretCan.IMPERSONATE_ROLE.name() ) ){
			sc.setAttribute( CaretStrPool.USER_ID, impersonateId );
			Long impersonateRoleId = (Long)request.getPortletSession().getAttribute(CaretStrPool.IMPERSONATE_ROLE_ID);
			if ( impersonateRoleId != null ){
				roleId = impersonateRoleId;
			}
		} else {
			sc.setAttribute( CaretStrPool.USER_ID, themeDisplay.getUser().getUserId() );
			roleId = controller.getRoleId();
		}
		
		sc.setAttribute( CaretStrPool.ROLE_ID, roleId );
		sc.setAttribute( CaretStrPool.DASHBOARD_ROLE_NAME, controller.getRole() );
		
		return sc;
	}
	

	
//	public static Map<String, Boolean> loadPermission ( PortletRequest request ) {
//		Map<String, Boolean> map = CAction.getMap( request );
//		request.setAttribute( "hasPermission_", map);
//		return map;
//	}

	
	public static Object trackNdx(PortletRequest request) {

		String[] tracker = (String[])request.getPortletSession().getAttribute(CaretStrPool.TRACKER);
		int trackerNdx = 0;
		PortletSession session = request.getPortletSession();
		if ( tracker == null ) {
			tracker = new String[TRACKER_MAX_SIZE];
			session.setAttribute(CaretStrPool.TRACKER, tracker);
			session.setAttribute(CaretStrPool.TRACKER_NDX, trackerNdx);
		} else {
			trackerNdx = (Integer)session.getAttribute(CaretStrPool.TRACKER_NDX);
			session.setAttribute(CaretStrPool.TRACKER_NDX, (trackerNdx+1)%TRACKER_MAX_SIZE );
		}
		tracker[trackerNdx] = StringUtil.randomString();
		return tracker[trackerNdx];
	}
	
	public static boolean isTracked ( PortletRequest request, String tracking ){
		return isTracked(request, tracking, false);
	}
	
	public static boolean isTracked ( PortletRequest request, String tracking, boolean remove ){
		String[] tracker = (String[])request.getPortletSession().getAttribute(CaretStrPool.TRACKER);
		_log.info("checking into tracker... " + tracking );
		if ( tracker == null ) {
			return false;
		} else {
			for ( int i = 0; i < tracker.length; i++ ){
				if ( tracking.equals( tracker[i] ) ){
					if ( remove ){
						tracker[i] = null; 
					}
					return true;
				}
			}
		}
		return false;
	}
	
	
	public static Date getSocDueDate(){
		if ( CaretParam.callSocDays == 0 ){
			try{
				CaretParam.callSocDays = Double.valueOf( PortletProps.get("call.soc.days") );
			}catch(Exception e){
				ApplicationWorkFlowException.handleException(e);
			}
		}
		Date socInclusion = Toolbox.subtractFromNow( CaretParam.callSocDays );
		_log.info("Current time: " + new Date() + ", SOC Inclusion date=" + socInclusion );
		return socInclusion;
	}
	
	public static String getSocDueDateStr(){
		if ( CaretParam.callSocDays == 0 ){
			try{
				CaretParam.callSocDays = Double.valueOf( PortletProps.get("call.soc.days") );
			}catch(Exception e){
				ApplicationWorkFlowException.handleException(e);
			}
		}
		Date socInclusion = Toolbox.subtractFromNow( CaretParam.callSocDays );
		_log.info("Current time: " + new Date() + ", SOC Inclusion date=" + socInclusion );
		return  Toolbox.getDateTimeFormat().format(socInclusion);
	}

	
	private static int TRACKER_MAX_SIZE = 10;
	public static Log _log = LogFactoryUtil.getLog( CaretParam.class );

	public static String InListProvider(String string) {
		if ( string == null || string.trim().isEmpty() ){
			return CaretStrPool.NDX;
		}
		StringBuilder sb = new StringBuilder(StringPool.COMMA);
		for ( String next: string.split(StringPool.COMMA) ){
			sb.append(StringPool.APOSTROPHE).append(next).append(CaretStrPool.APOSTROPHE_COMMA);
		}
		return sb.substring(2,sb.length()-2);
	}
}
